/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWAssociationTargetType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.Vector;

public class VWAssociationDefinition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 464L;
    private int targetId;
    private int targetType;
    private String name;
    protected int id = -1;
    private VWTextAnnotationDefinition myTextAnnotation = null;
    private Object originalConnectorGraphicsInfosNode = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:20:16 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/4 $";
    }

    protected VWAssociationDefinition(VWTextAnnotationDefinition tad, int id, int targetId, int targetType) throws VWException {
        this.setTextAnnotation(tad);
        this.setId(id);
        this.setTargetId(targetId);
        this.setTargetType(targetType);
    }

    protected Object clone() {
        try {
            VWAssociationDefinition clonedAssociation = (VWAssociationDefinition)super.clone();
            return clonedAssociation;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWAssociationDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t\t<Association\n");
        theBuffer.append(ATTRIB_INDENT + "TargetId=\"" + VWXMLHandler.toXMLString(Integer.toString(this.targetId)) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "TargetType=\"" + VWXMLHandler.toXMLString(VWAssociationTargetType.typeToString(this.targetType)) + "\"");
        if (this.name != null) {
            theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.name) + "\"");
        } else {
            theBuffer.append("\n");
        }
        theBuffer.append("/>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWAssociationDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        VWWorkflowDefinition wfdef = this.myTextAnnotation.getMap().getWorkflow();
        String prefix = "Workflow" + wfdef.getWorkflowCollection().getWorkflowIndex(wfdef.getName()) + ".Map" + wfdef.getMapIndex(this.myTextAnnotation.getMap().getName()) + ".";
        theBuffer.append(indentA + "<Association Id=\"" + prefix + this.myTextAnnotation.getId() + "." + this.getTargetId() + "." + this.getTargetType() + "\" Source=\"" + prefix + "Artifact" + this.myTextAnnotation.getId() + "\" Target=\"" + prefix + VWAssociationTargetType.typeToString(this.getTargetType()) + this.getTargetId() + "\"");
        if (this.getName() != null) {
            theBuffer.append(" Name=\"" + this.getName() + "\"");
        }
        if (this.originalConnectorGraphicsInfosNode == null) {
            theBuffer.append("/>\n");
        } else {
            theBuffer.append(">\n");
            VWXMLHandler.writeXMLNode(this.originalConnectorGraphicsInfosNode, VWXMLHandler.incXMLIndent(indentA), theBuffer);
            theBuffer.append(indentA + "</Association>\n");
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.targetId + ":" + this.targetType + "]";
    }

    public void validate(Vector EDefVector, VWMapDefinition map, int id) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(null, EDefVector);
        this.validate(validationContext, map, id);
    }

    protected void validate(VWValidationContext validationContext, VWMapDefinition map, int id) throws VWException {
        if (map != null) {
            switch (this.targetType) {
                case 1: {
                    try {
                        map.getStep(this.targetId);
                    }
                    catch (Exception e) {
                        VWString theMessage = new VWString("vw.api.VWAssociationDefinitionNoSuchNode", "The Annotation has a reference to a step (id = {0}) which does not exist in map {1}.", String.valueOf(this.targetId), map.getName());
                        VWValidationError theError = new VWValidationError(12, 2, null, null, theMessage.toString(), map.getName(), id);
                        validationContext.addValidationError(theError);
                    }
                    break;
                }
                case 2: {
                    try {
                        map.getRoute(this.targetId);
                    }
                    catch (Exception e) {
                        VWString theMessage = new VWString("vw.api.VWAssociationDefinitionNoSuchRoute", "The Annotation has a reference to a route (id = {0}) which does not exist in map {1}.", String.valueOf(this.targetId), map.getName());
                        VWValidationError theError = new VWValidationError(12, 2, null, null, theMessage.toString(), map.getName(), id);
                        validationContext.addValidationError(theError);
                    }
                    break;
                }
            }
        }
    }

    public int getTargetId() {
        return this.targetId;
    }

    protected void setTargetId(int targetId) throws VWException {
        this.targetId = targetId;
    }

    public int getTargetType() {
        return this.targetType;
    }

    protected void setTargetType(int targetType) throws VWException {
        if (!VWAssociationTargetType.isValid(targetType)) {
            throw new VWException("vw.api.VWAssociationDefinitionInvalidTargetType", "target type {0} is invalid.", String.valueOf(targetType));
        }
        this.targetType = targetType;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.targetId;
        result = 31 * result + this.targetType;
        result = 32 * result + (this.myTextAnnotation == null ? 0 : this.myTextAnnotation.hashCode());
        result = 32 * result + (this.originalConnectorGraphicsInfosNode == null ? 0 : this.originalConnectorGraphicsInfosNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            VWAssociationDefinition assn = (VWAssociationDefinition)obj;
            return assn.getTargetId() == this.targetId && assn.getTargetType() == this.targetType && assn.getTextAnnotation() == this.myTextAnnotation;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws VWException {
        this.name = name;
    }

    public int getId() throws VWException {
        return this.id;
    }

    protected void setId(int id) throws VWException {
        this.id = id;
    }

    public VWTextAnnotationDefinition getTextAnnotation() {
        return this.myTextAnnotation;
    }

    protected void setTextAnnotation(VWTextAnnotationDefinition tad) throws VWException {
        if (tad == null) {
            throw new VWException("vw.api.VWAssociationDefinitionInvalidtextAnnotation", "The text annotation cannot be null.");
        }
        this.myTextAnnotation = tad;
    }

    protected void setOriginalConnectorGraphicsInfosNode(Object obj) {
        this.originalConnectorGraphicsInfosNode = obj;
    }

    protected Object getOriginalConnectorGraphicsInfosNode() {
        return this.originalConnectorGraphicsInfosNode;
    }
}

